#Author: Dr.C. Sweetlin Hemalatha, Associate Professor, School of Computing Science & Engineering, VIT Chennai
#Ex10-Numerical Measures on data
#R version 3.3.3
#RStudio version 1.2.1335
rm(list=ls())

library(MASS)
newsurvey <- na.omit(survey)
options(digits=2)

#1.  Find the average age of the students participated in the survey.
age <- newsurvey$Age
print(mean(age))

#2.  Compute the standard deviation and variance of the height of the students participated in the survey.
ht <- newsurvey$Height
print(sd(ht))
print(var(ht))

#3.  Compute the quartile of wirte hand span.
wh <- newsurvey$Wr.Hnd
print(quantile(wh))

#4.  Find the correlation between write hand span and pulse rate of the students.
pr <- newsurvey$Pulse
print(cor(wh,pr))

#5.  Find the average age of the students based on how often the student exercises.
print(tapply(age,newsurvey$Exer,mean))

#6.  Find the standard deviation of height of the students based on writing hand.
print(tapply(ht,newsurvey$W.Hnd,mean))

#7.  Obtain the summary statistics of pulse rate of the students.
print(summary(pr))
